package com.ejie.ab04b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.CnaeJ73;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * RamasDao generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

public interface CnaeJ73Dao {

	/**
	 * Finds a single row in the Ramas table.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  CnaeJ73
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the cnae J 73
	 */
	CnaeJ73 find(CnaeJ73 cnaej73);

	/**
	 * Finds a List of rows in the Ramas table.
	 * 
	 *  cnaeJ73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param cnaeJ73 the cnae J 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<CnaeJ73> findAll(CnaeJ73 cnaeJ73, JQGridRequestDto jqGridRequestDto);

	/**
	 * Obtiene las ramas principales (de primer nivel).
	 * 
	 *  cnaeJ73            CnaeJ73
	 *  List<Vramas>
	 *
	 * @param cnaeJ73 the cnae J 73
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllNivelSuperior(CnaeJ73 cnaeJ73);

	/**
	 * Obtiene las ramas de una seccion.
	 * 
	 *  cnaeJ73            CnaeJ73
	 *  List<Vramas>
	 *
	 * @param cnaeJ73 the cnae J 73
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllBySeccion(CnaeJ73 cnaeJ73);

	/**
	 * Obtiene las ramas de una CNAE.
	 * 
	 *  cnaeJ73            CnaeJ73
	 *  List<cnaeJ73>
	 *
	 * @param cnaeJ73 the cnae J 73
	 * @return the cnae J 73
	 */
	@Transactional(readOnly = true)
	public CnaeJ73 findByCnae(CnaeJ73 cnaeJ73);

	/**
	 * Finds rows in the Ramas table using like.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<CnaeJ73> findAllLike(CnaeJ73 cnaej73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the Ramas table using like.
	 * 
	 *  cnaeJ73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param cnaeJ73 the cnae J 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<CnaeJ73> findAllForAutocomplete(CnaeJ73 cnaeJ73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
